--[[
	Bongos PvP
		capture bar
--]]

local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local Capture = Bongos:NewModule('Capture')
local PvP = Bongos:GetModule('PvP')
local NUM_CAPTURES = 0


--[[ Startup ]]--

function Capture:Load()
	local defaults = {
		point = 'TOPRIGHT',
		y = -350.4,
		x = -14,
	}

	self.bar, isNew = PvP:CreateBar('capture', defaults, nil, 'MEDIUM')
	if isNew then
		for k,v in pairs(self) do self.bar[k] = v end
	end
end

function Capture:Unload()
	self.bar:Destroy()
end


--[[ Size Update ]]--

function Capture:UpdateSize()
	local width, height = 173 
	if NUM_EXTENDED_UI_FRAMES > 0 then
		height = NUM_EXTENDED_UI_FRAMES * 26
		
		if NUM_EXTENDED_UI_FRAMES > NUM_CAPTURES then
			for i = NUM_CAPTURES + 1, NUM_EXTENDED_UI_FRAMES do
				local capture = _G["WorldStateCaptureBar"..i]
				capture:ClearAllPoints()
				capture:SetPoint("TOPRIGHT", self, "TOPRIGHT", 0, -26 * i)
				self:Attach(capture)
			end
			NUM_CAPTURES = NUM_EXTENDED_UI_FRAMES
		end
	else
		if Bongos:IsLocked() then
			height, width = 0.1, 0.1
		else
			height = 78
		end
	end
	
	self:SetHeight(height)
	self:SetWidth(width)
end